<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Banner;

class BannerController extends Controller
{

    private $banner;

    public function __construct(Banner $banner)
    {
        $this->banner = $banner;
    }

    public function index()
    {
        $user = auth('api')->user();
        
        if ($user->type === 'admin') {
            $banners = $this->banner->get();
        } else {
            $banners = $this->banner->where('tenant_id', $user->tenant_id)->get();
        }

        return response()->json($banners);
    }

    public function store(Request $request)
    {
        $input = $request->all();
        $input['link'] = Str::kebab($request->name);
        
        $banner = $this->banner->create($input);

        if ($request->hasFile('image') && $request->file('image')->isValid())
        {
            Banner::uploadBannerPicture($request->file('image'), $banner->tenant_id, $banner->link);
        }

        return response()->json($banner, 201);
    }

    public function show($id)
    {
        if (!$banner = $this->banner->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($banner);
    }

    public function update(Request $request, $id)
    {
        
    }
    
    public function updateSecondary(Request $request, $id)
    {
        $input = $request->all();
        $input['link'] = Str::kebab($request->name);
        
        if (!$banner = $this->banner->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }
        
        if ($request->hasFile('image'))
        {
            Banner::deleteBannerPicture($banner->tenant_id, $banner->link);
            if ($request->file('image')->isValid())
            {
                Banner::uploadBannerPicture($request->file('image'), $banner->tenant_id, $banner->link);
            }
        }

        $banner->update($input);

        return response()->json($banner);
    }

    public function destroy($id)
    {
        if (!$banner = $this->banner->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }
        
        // Delete picture
        Banner::deleteBannerPicture($banner->tenant_id, $banner->link);

        $banner->delete();

        return response()->json([], 204);
    }

}
