<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;

class CategoryController extends Controller
{
    private $category;
    
    public function __construct(Category $category)
    {
        $this->category = $category;
    }

    public function index()
    {
        $categories = $this->category->get();

        return response()->json($categories);
    }

    public function store(Request $request)
    {
       $category = $this->category->create($request->all());

        return response()->json($category, 201);
    }

    public function show($id)
    {
        if (!$category = $this->category->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($category);
    }

    public function update(Request $request, $id)
    {
        if (!$category = $this->category->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $category->update($request->all());

        return response()->json($category);
    }

    public function destroy($id)
    {
        if (!$category = $this->category->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $category->delete();

        return response()->json([], 204);
    }
}
