<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;

class CityController extends Controller
{
    private $city;
    
    public function __construct(City $city)
    {
        $this->city = $city;
    }

    public function index()
    {
        $cities = $this->city->get();

        return response()->json($cities);
    }

    public function store(Request $request)
    {
       $city = $this->city->create($request->all());

        return response()->json($city, 201);
    }

    public function show($id)
    {
        if (!$city = $this->city->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($city);
    }

    public function update(Request $request, $id)
    {
        if (!$city = $this->city->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $city->update($request->all());

        return response()->json($city);
    }

    public function destroy($id)
    {
        if (!$city = $this->city->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $city->delete();

        return response()->json([], 204);
    }
}
