<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Configuration;

class ConfigurationController extends Controller
{

    private $configuration;

    public function __construct(Configuration $configuration)
    {
        $this->configuration = $configuration;
    }

    public function index()
    {
        
    }

    public function store(Request $request)
    {

    }

    public function show($id)
    {
        $configuration = $this->configuration->where('tenant_id', $id)->first();
        
        if (!$configuration)
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($configuration);
    }

    public function update(Request $request, $id)
    {
        
    }
    
    public function updateSecondary(Request $request, $id)
    {        
        $input = $request->all();
        $input['url'] = Str::kebab(auth()->user()->tenant->name);
        
        $configuration = $this->configuration->where('tenant_id', $id)->first();
        
        if (!$configuration)
        {
            return response()->json(['error' => 'Not Found'], 404);
        }
        
        // favicon
        if ($request->hasFile('favicon'))
        {
            Configuration::deletePicture($configuration->tenant_id, 'favicon');
            if ($request->file('favicon')->isValid())
            {
                Configuration::uploadPicture($request->file('favicon'), $configuration->tenant_id, 'favicon');
            }
        }
        
        // logo
        if ($request->hasFile('logo'))
        {
            Configuration::deletePicture($configuration->tenant_id, 'logo');
            if ($request->file('logo')->isValid())
            {
                Configuration::uploadPicture($request->file('logo'), $configuration->tenant_id, 'logo');
            }
        }
        
        // logo2
        if ($request->hasFile('logo2'))
        {
            Configuration::deletePicture($configuration->tenant_id, 'logo2');
            if ($request->file('logo2')->isValid())
            {
                Configuration::uploadPicture($request->file('logo2'), $configuration->tenant_id, 'logo2');
            }
        }

        $configuration->update($input);

        return response()->json($configuration);
    }

    public function destroy($id)
    {
        
    }

}
