<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Coupon;

class CouponController extends Controller
{
    private $coupon;
    
    public function __construct(Coupon $coupon)
    {
        $this->coupon = $coupon;
    }

    public function index()
    {
        $user = auth('api')->user();
        
        if ($user->type === 'admin') {
            $coupons = $this->coupon->get();
        } else {
            $coupons = $this->coupon->where('tenant_id', $user->tenant_id)->get();
        }

        return response()->json($coupons);
    }

    public function store(Request $request)
    {
       $coupon = $this->coupon->create($request->all());

        return response()->json($coupon, 201);
    }

    public function show($id)
    {
        if (!$coupon = $this->coupon->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($coupon);
    }

    public function update(Request $request, $id)
    {
        if (!$coupon = $this->coupon->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $coupon->update($request->all());

        return response()->json($coupon);
    }

    public function destroy($id)
    {
        if (!$coupon = $this->coupon->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $coupon->delete();

        return response()->json([], 204);
    }
}
