<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Courier;

class CourierController extends Controller
{
    private $courier;
    
    public function __construct(Courier $courier)
    {
        $this->courier = $courier;
    }

    public function index()
    {
        $user = auth('api')->user();
        
        if ($user->type === 'admin') {
            $couriers = $this->courier->get();
        } else {
            $couriers = $this->courier->where('tenant_id', $user->tenant_id)->get();
        }

        return response()->json($couriers);
    }

    public function store(Request $request)
    {
        $courier = $this->courier->create($request->all());

        return response()->json($courier, 201);
    }

    public function show($id)
    {
        if (!$courier = $this->courier->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($courier);
    }

    public function update(Request $request, $id)
    {
        if (!$courier = $this->courier->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $courier->update($request->all());

        return response()->json($courier);
    }

    public function destroy($id)
    {
        if (!$courier = $this->courier->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $courier->delete();

        return response()->json([], 204);
    }
}
