<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\GatewayPayment;

class GatewayPaymentController extends Controller
{
    private $gatewayPayment;
    
    public function __construct(GatewayPayment $gatewayPayment)
    {
        $this->gatewayPayment = $gatewayPayment;
    }

    public function index()
    {
        $gatewayPayments = $this->gatewayPayment->get();

        return response()->json($gatewayPayments);
    }

    public function store(Request $request)
    {
       $gatewayPayment = $this->gatewayPayment->create($request->all());

        return response()->json($gatewayPayment, 201);
    }

    public function show($id)
    {
        if (!$gatewayPayment = $this->gatewayPayment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($gatewayPayment);
    }

    public function update(Request $request, $id)
    {
        if (!$gatewayPayment = $this->gatewayPayment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $gatewayPayment->update($request->all());

        return response()->json($gatewayPayment);
    }

    public function destroy($id)
    {
        if (!$gatewayPayment = $this->gatewayPayment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $gatewayPayment->delete();

        return response()->json([], 204);
    }
}
