<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Neighborhood;

class NeighborhoodController extends Controller
{
    private $neighborhood;

    public function __construct(Neighborhood $neighborhood)
    {
        $this->neighborhood = $neighborhood;
    }

    public function index()
    {
        $neighborhoods = $this->neighborhood->get();

        return response()->json($neighborhoods);
    }

    public function store(Request $request)
    {
        $neighborhood = $this->neighborhood->create($request->all());

        return response()->json($neighborhood, 201);
    }

    public function show($id)
    {
        if (!$neighborhood = $this->neighborhood->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($neighborhood);
    }

    public function update(Request $request, $id)
    {
        if (!$neighborhood = $this->neighborhood->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $neighborhood->update($request->all());

        return response()->json($neighborhood);
    }

    public function destroy($id)
    {
        if (!$neighborhood = $this->neighborhood->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $neighborhood->delete();

        return response()->json([], 204);
    }

}
