<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payment;

class PaymentController extends Controller
{
    private $payment;
    
    public function __construct(Payment $payment)
    {
        $this->payment = $payment;
    }

    public function index()
    {
        $user = auth('api')->user();
        
        if ($user->type === 'admin') {
            $payments = $this->payment->with('gatewayPayment')->get();
        } else {
            $payments = $this->payment->where('tenant_id', $user->tenant_id)
                                      ->with('gatewayPayment')
                                      ->get();
        }

        return response()->json($payments);
    }

    public function store(Request $request)
    {
       $payment = $this->payment->create($request->all());

        return response()->json($payment, 201);
    }

    public function show($id)
    {
        if (!$payment = $this->payment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($payment);
    }

    public function update(Request $request, $id)
    {
        if (!$payment = $this->payment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $payment->update($request->all());

        return response()->json($payment);
    }

    public function destroy($id)
    {
        if (!$payment = $this->payment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $payment->delete();

        return response()->json([], 204);
    }
}
