<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use App\Models\Product;

class ProductController extends Controller
{

    private $product, $path = 'products';

    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    public function index()
    {
        $user = auth('api')->user();
        
        if ($user->type === 'admin') {
            $products = $this->product->get();
        } else {
            $products = $this->product->where('tenant_id', $user->tenant_id)->get();
        }

        return response()->json($products);
    }

    public function store(Request $request)
    {
        $product = $this->product->create($request->all());

        if ($request->hasFile('image') && $request->file('image')->isValid())
        {
            Product::uploadProductPicture($request->file('image'), $product->tenant_id, $product->id);            
        }

        return response()->json($product, 201);
    }

    public function show($id)
    {
        if (!$product = $this->product->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($product);
    }

    public function update(Request $request, $id)
    {
        
    }

    public function updateSecondary(Request $request, $id)
    {
        if (!$product = $this->product->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        if ($request->hasFile('image'))
        {
            Product::deleteProductPicture($product->tenant_id, $id);
            if ($request->file('image')->isValid())
            {
                Product::uploadProductPicture($request->file('image'), $product->tenant_id, $id);
            }
        }

        $product->update($request->all());

        return response()->json($product);
    }

    public function destroy($id)
    {
        if (!$product = $this->product->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }
        
        // Delete picture
        Product::deleteProductPicture($product->tenant_id, $id);

        $product->delete();

        return response()->json([], 204);
    }

}
