<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Segment;

class SegmentController extends Controller
{
    private $segment;
    
    public function __construct(Segment $segment)
    {
        $this->segment = $segment;
    }

    public function index()
    {
        $segments = $this->segment->get();

        return response()->json($segments);
    }

    public function store(Request $request)
    {
       $segment = $this->segment->create($request->all());

        return response()->json($segment, 201);
    }

    public function show($id)
    {
        if (!$segment = $this->segment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($segment);
    }

    public function update(Request $request, $id)
    {
        if (!$segment = $this->segment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $segment->update($request->all());

        return response()->json($segment);
    }

    public function destroy($id)
    {
        if (!$segment = $this->segment->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $segment->delete();

        return response()->json([], 204);
    }
}
