<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Subcategory;

class SubcategoryController extends Controller
{
    private $subcategory;
    
    public function __construct(Subcategory $subcategory)
    {
        $this->subcategory = $subcategory;
    }

    public function index()
    {
        $categories = $this->subcategory->get();

        return response()->json($categories);
    }

    public function store(Request $request)
    {
       $subcategory = $this->subcategory->create($request->all());

        return response()->json($subcategory, 201);
    }

    public function show($id)
    {
        if (!$subcategory = $this->subcategory->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        return response()->json($subcategory);
    }

    public function update(Request $request, $id)
    {
        if (!$subcategory = $this->subcategory->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $subcategory->update($request->all());

        return response()->json($subcategory);
    }

    public function destroy($id)
    {
        if (!$subcategory = $this->subcategory->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        $subcategory->delete();

        return response()->json([], 204);
    }
    
    // PESQUISAR SUBCATEGORIAS DE UMA CATEGORIA
    public function searchSubcategories($id)
    {
        $subcategories = Subcategory::where('category_id', $id)->select('id', 'name')->get();
        
        return response()->json($subcategories);
    }
}
