<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Tenant;
use App\Models\User;
use Tymon\JWTAuth\Facades\JWTAuth;
use Exception;

class TenantController extends Controller
{
    private $tenant, $user;

    public function __construct(Tenant $tenant, User $user)
    {
        $this->tenant = $tenant;
        $this->user = $user;
    }

    private function getAuthenticatedUser()
    {
        // Tentar diferentes headers
        $request = app('request');
        $token = $request->header('X-Authorization') ?:
                $request->header('X-Auth-Token') ?:
                $request->header('Authorization');
        
        if ($token) {
            $token = str_replace('Bearer ', '', $token);
            return JWTAuth::setToken($token)->authenticate();
        }
        
        throw new Exception('No token provided');
    }

    public function index()
    {
        try {
            $user = $this->getAuthenticatedUser();
            
            if ($user->type === 'admin') {
                $tenants = $this->tenant->where('type', 'E')->get();
            } else {
                $tenants = $this->tenant->where('id', $user->tenant_id)
                                        ->where('type', 'E')
                                        ->get();
            }

            return response()->json($tenants);
        } catch (Exception $e) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function show($id)
    {
        try {
            $user = $this->getAuthenticatedUser();
        } catch (Exception $e) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
        
        if (!$tenant = $this->tenant->find($id))
        {
            return response()->json(['error' => 'Not Found'], 404);
        }

        if ($user->type !== 'admin' && $tenant->id !== $user->tenant_id) {
            return response()->json(['error' => 'Unauthorized'], 403);
        }

        return response()->json($tenant);
    }

    // ... (outros métodos mantêm a mesma lógica com getAuthenticatedUser)
}
