<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Tenant;
use App\Models\User;

class TenantControllerFixed extends Controller
{
    private $tenant, $user;

    public function __construct(Tenant $tenant, User $user)
    {
        $this->tenant = $tenant;
        $this->user = $user;
    }

    public function index()
    {
        $user = auth('api')->user();
        
        // DEBUG
        error_log("User Type: '" . $user->type . "'");
        error_log("User Ty
        error_log("Comparison with 'admin': " . (trim($user->type) === 'admin' ? 'true' : 'false'));
        
        // Usar trim() e strtolower() para segurança
        $userType = strtolower(trim($user->type));
        
        if ($userType === 'admin') {
            $tenants = $this->tenant->where('type', 'E')->get();
        } else {
            $tenants = $this->tenant->where('id', $user->t
                                    ->where('type', 'E')
                                    ->get();
        }

        return response()->json($tenants);
    }
}
