<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Tenant;

class TenantControllerRobust extends Controller
{
    public function index()
    {
        $user = auth('api')->user();
        
        // DEBUG - Log para análise
        \Log::info('TenantController access', [
            'user_id' => $user->id,
            'user_type' => $user->type,
            'user_type_hex' => bin2hex($user->type),
            'tenant_id' => $user->tenant_id
        ]);
        
        // Método robusto: trim + lowercase
        $userType = strtolower(trim($user->type));
        
        if ($userType === 'admin') {
            // Admin vê todos estabelecimentos tipo E
            $tenants = Tenant::where('type', 'E')->get();
            \Log::info('Admin access - showing all', ['count' => $tenants->count()]);
        } else {
            // Não-admin vê apenas seu próprio estabelecimento
            $tenants = Tenant::where('id', $user->tenant_id)
                            ->where('type', 'E')
                            ->get();
            \Log::info('Client access - showing own', [
                'tenant_id' => $user->tenant_id,
                'count' => $tenants->count()
            ]);
        }
        
        return response()->json($tenants);
    }
}
