<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tenant;
use Tymon\JWTAuth\Facades\JWTAuth;

class TenantControllerTest extends Controller
{
    public function testIndex()
    {
        $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvYXBpLmV1bGV2b2FpLmNvbS5iclwvYXBpXC9sb2dpbiIsImlhdCI6MTc2OTAwMzY3MSwiZXhwIjoxNzY5MDM5NjcxLCJuYmYiOjE3NjkwMDM2NzEsImp0aSI6InRhTXZadVV2WFpXS2ZSaUYiLCJzdWIiOjcsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjciLCJ0ZW5hbnRfaWQiOjcsInR5cGUiOiJFIiwibmFtZSI6IkpvcmdlIEx1aXMgU2FudG9zIGRlIFNhbnRhbmEgRUlSRUxJIiwiZW1haWwiOiJmcmlnb3JpZmljby5zYW8uam9yZ2VAaG90bWFpbC5jb20ifQ.HaKQztPbTMmhZ9xeZHBf2y2JcDsEg__uMAjmSViy-yA';
        JWTAuth::setToken($token);
        $user = JWTAuth::authenticate();
        
        echo "User ID: " . $user->id . "\n";
        echo "User Type: " . $user->type . "\n";
        echo "User Tenant ID: " . $user->tenant_id . "\n";
        
        // Testar lógica
        if ($user->type === 'admin') {
            echo "Logic: User is ADMIN - should see ALL\n";
            $tenants = Tenant::where('type', 'E')->get();
        } else {
            echo "Logic: User is NOT ADMIN - should see only tenant " . $user->tenant_id . "\n";
            $tenants = Tenant::where('id', $user->tenant_id)
                            ->where('type', 'E')
                            ->get();
        }
        
        echo "Count: " . $tenants->count() . "\n";
        echo "Tenant IDs: ";
        foreach ($tenants as $tenant) {
            echo $tenant->id . " ";
        }
        echo "\n";
    }
}
