<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Tenant;

class TenantControllerUniversal extends Controller
{
    public function index()
    {
        $user = auth('api')->user();
        
        // Log para debug
        error_log("=== TENANT CONTROLLER DEBUG ===");
        error_log("User ID: " . $user->id);
        error_log("User Type RAW: '" . $user->type . "'");
        error_log("User Type HEX: " . bin2hex($user->type));
        error_log("User Type Length: " . strlen($user->type));
        error_log("User Tenant ID: " . $user->tenant_id);
        
        // Método universal: tratar vários casos
        $userType = strtolower(trim($user->type));
        
        // Lista de valores que indicam admin
        $adminValues = ['admin', 'a', 'administrator', 'adm'];
        
        if (in_array($userType, $adminValues)) {
            // Admin vê todos
            $tenants = Tenant::where('type', 'E')->get();
            error_log("Access: ADMIN - Showing all (" . $tenants->count() . ")");
        } else {
            // Não-admin vê apenas seu tenant
            $tenants = Tenant::where('id', $user->tenant_id)
                            ->where('type', 'E')
                            ->get();
            error_log("Access: CLIENT - Showing tenant " .
        }
        
        return response()->json($tenants);
    }
}
