<?php
// Solução alternativa para TenantController
public function index()
{
    try {
        $user = JWTAuth::parseToken()->authenticate();
        
        if ($user->type === 'admin') {
            $tenants = $this->tenant->where('type', 'E')->get();
        } else {
            $tenants = $this->tenant->where('id', $user->tenant_id)
                                    ->where('type', 'E')
                                    ->get();
        }
        return response()->json($tenants);
    } catch (Exception $e) {
        return response()->json(['error' => 'Unauthorized'], 401);
    }
}
