<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;
use Exception;

class TestController extends Controller
{
    public function testAuth(Request $request)
    {
        echo "=== DEBUG TEST ===\n";
        
        // Testar todos os headers possíveis
        echo "Authorization Header: " . $request->header('Authorization') . "\n";
        echo "X-Authorization Header: " . $request->header('X-Authorization') . "\n";
        echo "X-Auth-Token Header: " . $request->header('X-Auth-Token') . "\n";
        echo "HTTP_AUTHORIZATION (server): " . ($_SERVER['HTTP_AUTHORIZATION'] ?? 'NOT SET') . "\n";
        echo "REDIRECT_HTTP_AUTHORIZATION: " . ($_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? 'NOT SET') . "\n";
        
        // Tentar com header alternativo
        $token = $request->header('X-Authorization') ?: 
                $request->header('X-Auth-Token') ?:
                $request->header('Authorization');
        
        echo "Token to use: " . substr($token ?: 'EMPTY', 0, 50) . "\n";
        
        if ($token) {
            // Remover 'Bearer ' se presente
            $token = str_replace('Bearer ', '', $token);
            
            try {
                $user = JWTAuth::setToken($token)->authenticate();
                echo "SUCCESS! User authenticated: " . $user->id . "\n";
                return response()->json(['success' => true, 'user' => $user->id]);
            } catch (Exception $e) {
                echo "ERROR: " . $e->getMessage() . "\n";
                return response()->json(['error' => $e->getMessage()], 401);
            }
        }
        
        return response()->json(['error' => 'No token provided'], 401);
    }

    public function testSimple()
    {
        return response()->json(['message' => 'Simple test works']);
    }
}
