<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    public function index()
    {
        $user = auth('api')->user();
        
        if ($user->type === 'admin') {
            $users = User::all();
        } else {
            $users = User::where('tenant_id', $user->tenant_id)->get();
        }

        return response()->json($users);
    }

    public function store(Request $request)
    {
        // Implementação original (preservar)
        $input = $request->all();
        $user = User::create($input);
        return response()->json($user, 201);
    }

    public function show($id)
    {
        // Implementação original (preservar)
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'Not Found'], 404);
        }
        return response()->json($user);
    }

    public function update(Request $request, $id)
    {
        // Implementação original (preservar)
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'Not Found'], 404);
        }
        $user->update($request->all());
        return response()->json($user);
    }

    public function destroy($id)
    {
        // Implementação original (preservar)
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'Not Found'], 404);
        }
        $user->delete();
        return response()->json([], 204);
    }
}
