<?php

namespace App\Http\Middleware;

use Closure;
use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;
use Tymon\JWTAuth\Facades\JWTAuth;
use Exception;

class ApiProtectedRouteDebug extends BaseMiddleware
{
    public function handle($request, Closure $next)
    {
        echo "=== MIDDLEWARE DEBUG ===\n";
        echo "Headers recebidos:\n";
        foreach ($request->headers->all() as $key => $value) {
            echo "  $key: " . implode(', ', $value) . "\n";
        }
        
        echo "\nServer vars:\n";
        echo "  HTTP_AUTHORIZATION: " . ($_SERVER['HTTP_AUTHORIZATION'] ?? 'NOT SET') . "\n";
        echo "  REDIRECT_HTTP_AUTHORIZATION: " . ($_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? 'NOT SET') . "\n";
        
        // Tentar TODOS os headers
        $token = $request->header('X-Authorization') ?:
                $request->header('X-Auth-Token') ?:
                $request->header('Authorization') ?:
                ($_SERVER['HTTP_AUTHORIZATION'] ?? null) ?:
                ($_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? null);
        
        echo "\nToken encontrado: " . ($token ? substr($token, 0, 50) . "..." : 'NULL') . "\n";
        
        if ($token) {
            $token = str_replace('Bearer ', '', $token);
            $request->headers->set('Authorization', 'Bearer ' . $token);
            echo "Token processado: " . substr($token, 0, 30) . "...\n";
            
            try {
                $user = JWTAuth::parseToken()->authenticate();
                echo "✅ Usuário autenticado: ID=" . $user->id . ", Type=" . $user->type . ", Tenant=" . $user->tenant_id . "\n";
                
                // Testar auth('api')->user() também
                $authUser = auth('api')->user();
                echo "auth('api')->user(): " . ($authUser ? "ID=" . $authUser->id : "NULL") . "\n";
                
            } catch (Exception $e) {
                echo "❌ Erro na autenticação: " . $e->getMessage() . "\n";
                return response()->json(['debug_error' => $e->getMessage()], 401);
            }
        } else {
            echo "❌ Nenhum token encontrado\n";
            return response()->json(['debug_error' => 'No token found'], 401);
        }
        
        return $next($request);
    }
}
