<?php

namespace App\Http\Middleware;

use Closure;
use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;
use Tymon\JWTAuth\Facades\JWTAuth;
use Exception;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;

class ApiProtectedRoute extends BaseMiddleware
{
    public function handle($request, Closure $next)
    {
        // Tentar diferentes headers
        $token = $request->header('X-Authorization') ?: 
                $request->header('X-Auth-Token') ?:
                $request->header('Authorization');
        
        if ($token) {
            // Remover 'Bearer ' se presente
            $token = str_replace('Bearer ', '', $token);
            $request->headers->set('Authorization', 'Bearer ' . $token);
        }
        
        try
        {
            $user = JWTAuth::parseToken()->authenticate();
        }
        catch (Exception $e)
        {
            if ($e instanceof TokenInvalidException)
            {
                return response()->json(['status' => 'Token is Invalid']);
            }
            elseif ($e instanceof TokenExpiredException)
            {
                return response()->json(['status' => 'Token is Expired']);
            }
            else
            {
                return response()->json(['status' => 'Authorization Token not found']);
            }
        }

        return $next($request);
    }
}
