<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Tenant;

class ForceTenantFilter
{
    public function handle($request, Closure $next)
    {
        $response = $next($request);
        
        // Se response é JSON e contém estabelecimentos/tenants
        if ($response->headers->get('Content-Type') === 'application/json') {
            $content = json_decode($response->getContent(), true);
            
            // Verificar se é array de estabelecimentos/tenants
            if (is_array($content) && isset($content[0]['id']) && isset($content[0]['type'])) {
                $user = auth('api')->user();
                if ($user && $user->type !== 'admin') {
                    // Filtrar apenas do tenant do usuário
                    $filtered = array_filter($content, function($item) use ($user) {
                        return isset($item['id']) && $item['id'] == $user->tenant_id;
                    });
                    $response->setContent(json_encode(array_values($filtered)));
                }
            }
        }
        
        return $response;
    }
}
