<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;
use Image;

class Banner extends Model
{
    use TenantTrait;

    protected $fillable = [
        'name',
        'link',
        'local',
        'ranking',
    ];
    
    
    // UPLOAD PHOTO
    public static function uploadBannerPicture($picture, $tenant_id, $link)
    {
        // set directory
        $directory = public_path("images/{$tenant_id}/banners/");

        // create the directory
        if (!is_dir($directory)) {
            mkdir($directory, 0755, true);
        }

        // resize and save image
        $img = Image::make($picture);
        $img->resize(200, null, function ($constraint) {
            $constraint->aspectRatio();
            $constraint->upsize();
        })->save($directory . "{$link}.jpg", 80);
    }

    // DELETE PHOTO
    public static function deleteBannerPicture($tenant_id, $link)
    {
        // set source of file
        $src = "images/{$tenant_id}/banners/{$link}.jpg";

        // verify if image exists and delete
        if (is_file(public_path($src))) {
            unlink(public_path($src));
        }
    }       


    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
