<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;

class Category extends Model
{

    use TenantTrait;

    protected $fillable = [
        'name',
        'description',
    ];    

    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    public function products() 
    {
        return $this->hasMany(Product::class);
    }
    
    public function subcategories() 
    {
        return $this->hasMany(Subcategory::class);
    }

}
