<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;
use Image;

class Configuration extends Model
{
    use TenantTrait;

    protected $fillable = [
        'layout',
        'color',
        'title',
        'description',
        'keywords',
        'facebook',
        'instagram',
        'whatsapp',
        'url',
        'minimum_order',
    ];
    
    
    // UPLOAD PHOTO
    public static function uploadPicture($picture, $tenant_id, $type)
    {
        // set directory
        $directory = public_path("images/{$tenant_id}/");

        // create the directory
        if (!is_dir($directory)) {
            mkdir($directory, 0755, true);
        }

        // resize and save image
        $img = Image::make($picture);
        $img->resize(200, null, function ($constraint) {
            $constraint->aspectRatio();
            $constraint->upsize();
        })->save($directory . "{$type}.jpg", 80);
    }

    // DELETE PHOTO
    public static function deletePicture($tenant_id, $type)
    {
        // set source of file
        $src = "images/{$tenant_id}/{$type}.jpg";

        // verify if image exists and delete
        if (is_file(public_path($src))) {
            unlink(public_path($src));
        }
    } 
    
    
    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}