<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;

class Neighborhood extends Model
{

    use TenantTrait;

    protected $fillable = [
        'name',
        'value',
    ];
    
    
    public function setValueAttribute($value)
    {
        $this->attributes['value'] = str_replace(',', '.', str_replace('.', '', $value));
    }

    public function getValueAttribute($value)
    {
        return number_format($value, 2, ',', '.');
    }
    

    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
