<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;

class Payment extends Model
{

    use TenantTrait;

    protected $fillable = [
        'gateway_payment_id',
        'limit_parcel',
        'limit_parcel_interest_free',
        'discount_slip',
    ];

    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    public function gatewayPayment()
    {
        return $this->belongsTo(GatewayPayment::class);
    }

}