<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;
use Image;

class Product extends Model
{

    use TenantTrait;

    protected $fillable = [
        'name',
        'code',
        'quantity',
        'price',
        'category_id',
        'subcategory_id',
        'observation',
    ];   
    
    
    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = str_replace(',', '.', str_replace('.', '', $value));
    }

    public function getPriceAttribute($value)
    {
        return number_format($value, 2, ',', '.');
    }  
        
    
    // UPLOAD PHOTO
    public static function uploadProductPicture($picture, $tenant_id, $id)
    {
        // set directory
        $directory = public_path("images/{$tenant_id}/produtos/");

        // create the directory
        if (!is_dir($directory)) {
            mkdir($directory, 0755, true);
        }

        // resize and save image
        $img = Image::make($picture);
        $img->resize(200, null, function ($constraint) {
            $constraint->aspectRatio();
            $constraint->upsize();
        })->save($directory . "{$id}.jpg", 80);
    }

    // DELETE PHOTO
    public static function deleteProductPicture($tenant_id, $id)
    {
        // set source of file
        $src = "images/{$tenant_id}/produtos/{$id}.jpg";

        // verify if image exists and delete
        if (is_file(public_path($src))) {
            unlink(public_path($src));
        }
    }       


    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

}
