<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\Traits\TenantTrait;

class Subcategory extends Model
{
    use TenantTrait;

    protected $fillable = [
        'category_id',
        'name',
    ];    

    // relation
    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
    
    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
