<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

//use Image;

class Tenant extends Model
{

    //
    protected $fillable = [
        'hash',
        'type',
        'cpf_cnpj',
        'name',
        'phone',
        'mobile',
        'email',
        'cep',
        'state',
        'city',
        'neighborhood',
        'street',
        'number',
        'complement',
        'reference',
        'segments'
    ];

    public function getSegmentsAttribute($value)
    {
        if (!empty($value))
        {
            return json_decode($value, true);
        }
        else
        {
            return;
        }
    }

    public function setSegmentsAttribute($value)
    {
        if (!empty($value))
        {
            $this->attributes['segments'] = json_encode($value);
        }
    }

//    // UPLOAD PHOTO
//    public static function uploadCompanyPicture($picture, $id)
//    {
//        // set directory
//        $directory = public_path("images/company/");
//
//        // get file extension
//        $ext = $picture->getClientOriginalExtension();
//
//        // create the directory
//        if (!is_dir($directory)) {
//            mkdir($directory, 0755, true);
//        }
//
//        // resize and save image
//        $img = Image::make($picture);
//        $img->resize(200, null, function ($constraint) {
//            $constraint->aspectRatio();
//            $constraint->upsize();
//        })->save($directory . "{$id}.png", 80);
//    }
//
//    // DELETE PHOTO
//    public static function deleteCompanyPicture($id)
//    {
//        // set source of file
//        $src = "images/company/{$id}.png";
//
//        // verify if image exists and delete
//        if (is_file(public_path($src))) {
//            unlink(public_path($src));
//        }
//    }
    // relation
    public function users()
    {
        return $this->hasMany(User::class);
    }

}
