<?php

namespace App\Observers\Tenant;

use Illuminate\Database\Eloquent\Model;
use App\Tenant\ManagerTenant;

class TenantObserver {
    
    // executa este evento antes de criar o registro
    public function creating(Model $model)
    {
        // utilizando o app() não é preciso fazer new ManagerTenant, ele faz automaticamente
        $tenant = app(ManagerTenant::class)->getTenantIdentify();
        
        $model->setAttribute('tenant_id', $tenant);
    }
}

