<?php

namespace App\Rules\Tenant;

use Illuminate\Contracts\Validation\Rule;
use App\Tenant\ManagerTenant;

class TenantUnique implements Rule
{
    
    private $table, $column, $columnValue;
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($table, $columnValue = null, $column = 'id')
    {
        //
        $this->table = $table;
        $this->columnValue = $columnValue;
        $this->column = $column;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        //
        $tenant = app(ManagerTenant::class)->getTenantIdentify();
        
        // verifica se existe um atributo com valor repetido para cada tenant (company)
        $result = \DB::table($this->table)->where($attribute, $value)->where('tenant_id', $tenant)->first();
        
        // se result diferente de null e valor da colunm for igual o da columnValue - retorna true deixando passar
        if($result && $result->{$this->column} == $this->columnValue) {
            return true;
        }
        
        // se retorna null está OK
        return is_null($result);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'O valor para o campo :attribute já está em uso!';
    }
}
