<?php

namespace App\Scopes\Tenant;

use Illuminate\Database\Eloquent\Scope;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

use App\Tenant\ManagerTenant;

class TenantScope implements Scope {

    // builder -> passa a query
    // model -> pega a model na qual ele foi instanciado
    public function apply(Builder $builder, Model $model) 
    {
        // utilizando o app() não é preciso fazer new ManagerTenant, ele faz automaticamente
        $tenant = app(ManagerTenant::class)->getTenantIdentify();
        
        $builder->where('tenant_id', $tenant);
    }
}