<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTenantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tenants', function (Blueprint $table) {
            $table->bigIncrements('id');
            
            // 
            $table->string('hash')->nullable();
            $table->char('type', 1); // A - Administrador Geral / E - Estabelecimento
            
            // DADOS PESSOAIS
            $table->string('cpf_cnpj', 18)->unique();            
            $table->string('name', 100);
            $table->string('phone', 15)->nullable();
            $table->string('mobile', 15)->nullable();
            $table->string('email', 70)->nullable();
            
            // ENDEREÇO
            $table->string('cep', 9)->nullable();
            $table->string('state', 2)->nullable();
            $table->string('city', 40)->nullable();
            $table->string('neighborhood', 40)->nullable();
            $table->string('street', 120)->nullable();
            $table->integer('number')->nullable();
            $table->string('complement', 30)->nullable();
            $table->string('reference', 150)->nullable(); 
            
            // SEGMENTO
            $table->longText('segments')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tenants');
    }
}
