<?php

//Route::middleware('auth:api')->get('/user', function (Request $request) {
//    return $request->user();
//});


Route::post('login', 'Api\\AuthController@login');
Route::get('test-auth', 'Api\\TestController@testAuth');
Route::get('test-simple', 'Api\\TestController@testSimple');


Route::group([

    'middleware' => 'apiJwt',
    'namespace' => 'Api'

], function () {

    Route::post('logout', 'AuthController@logout');
    Route::post('refresh', 'AuthController@refresh');
    Route::post('me', 'AuthController@me');
    Route::post('alter-password/{id}', 'AuthController@alterPassword');

    // USERS
    Route::get('users', 'UserController@index');

    //CLIENTES
    Route::get('clients', 'ClientController@index');

    // CIDADE
    Route::apiResource('cities', 'CityController');

    // SEGMENTO
    Route::apiResource('segments', 'SegmentController');

    // ESTABELECIMENTO
    Route::apiResource('establishments', 'TenantController');

    // BAIRROS
    Route::apiResource('neighborhoods', 'NeighborhoodController');

    // CATEGORIAS
    Route::apiResource('categories', 'CategoryController');

    // SUBCATEGORIAS
    Route::post('categories/{id}/subcategories', 'SubcategoryController@searchSubcategories');
    Route::apiResource('subcategories', 'SubcategoryController');

    // PRODUTOS
    Route::post('products/{id}/editar', 'ProductController@updateSecondary');
    Route::apiResource('products', 'ProductController');

    // ENTREGADORES
    Route::apiResource('couriers', 'CourierController');

    // FORMA DE PAGAMENTO
    Route::apiResource('payments', 'PaymentController');

    // CUPOM DE DESCONTO
    Route::apiResource('coupons', 'CouponController');

    // BANNERS
    Route::post('banners/{id}/editar', 'BannerController@updateSecondary');
    Route::apiResource('banners', 'BannerController');

    // API DE PAGAMENTO
    Route::apiResource('gateways', 'GatewayPaymentController');

    // CONFIGURAÇÕES
    Route::post('configuration/{id}/editar', 'ConfigurationController@updateSecondary');
    Route::apiResource('configuration', 'ConfigurationController');



});
