<?php

Route::get('debug-establishments', function() {
    $user = auth('api')->user();
    if (!$user) {
        return response()->json(['error' => 'No user in controller'], 401);
    }
    
    // Simular TenantController logic
    if ($user->type === 'admin') {
        $tenants = \App\Models\Tenant::where('type', 'E')->get();
    } else {
        $tenants = \App\Models\Tenant::where('id', $user->tenant_id)
                                    ->where('type', 'E')
                                    ->get();
    }
    
    return response()->json([
        'user_id' => $user->id,
        'user_type' => $user->type,
        'user_tenant_id' => $user->tenant_id,
        'count' => $tenants->count(),
        'establishments' => $tenants
    ]);
})->middleware('apiJwt'); // Usar middleware normal para testar
