<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

use App\Models\User;
use App\Models\Tenant;

// Buscar usuário ID 7
$user = User::find(7);
if ($user) {
    echo "=== DADOS DO BANCO ===\n";
    echo "ID: " . $user->id . "\n";
    echo "Email: " . $user->email . "\n";
    echo "Type: '" . $user->type . "' (length: " . strlen($user->type) . ")\n";
    echo "Tenant ID: " . $user->tenant_id . "\n";
    
    echo "\n=== TESTE DE LÓGICA ===\n";
    echo "Comparação com 'admin': ";
    var_dump($user->type === 'admin');
    echo "Comparação com 'E': ";
    var_dump($user->type === 'E');
    echo "Trim comparison: ";
    var_dump(trim($user->type) === 'E');
    
    echo "\n=== QUERY RESULT ===\n";
    if (trim($user->type) === 'admin') {
        $tenants = Tenant::where('type', 'E')->get();
        echo "ADMIN: Verá todos os estabelecimentos\n";
    } else {
        $tenants = Tenant::where('id', $user->tenant_id)
                        ->where('type', 'E')
                        ->get();
        echo "CLIENTE: Verá apenas estabelecimento " . $user->tenant_id . "\n";
    }
    
    echo "Count: " . $tenants->count() . "\n";
    if ($tenants->count() > 0) {
        echo "IDs: ";
        foreach ($tenants as $t) {
            echo $t->id . " ";
        }
        echo "\n";
    }
} else {
    echo "Usuário não encontrado\n";
}
