<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

use Illuminate\Http\Request;
use App\Http\Kernel;

// Criar request simulada
$request = Request::create('/api/establishments', 'GET');
$request->headers->set('X-Authorization', 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvYXBpLmV1bGV2b2FpLmNvbS5iclwvYXBpXC9sb2dpbiIsImlhdCI6MTc2OTAwNDA0MCwiZXhwIjoxNzY5MDQwMDQwLCJuYmYiOjE3NjkwMDQwNDAsImp0aSI6ImRsQ2ZsME5uZ09qTFU1Y0oiLCJzdWIiOjcsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjciLCJ0ZW5hbnRfaWQiOjcsInR5cGUiOiJFIiwibmFtZSI6IkpvcmdlIEx1aXMgU2FudG9zIGRlIFNhbnRhbmEgRUlSRUxJIiwiZW1haWwiOiJmcmlnb3JpZmljby5zYW8uam9yZ2VAaG90bWFpbC5jb20ifQ.rm09B69xBozXpWY1d0jz2oVSZMNBCz0-NWCIaR2y9vE');

$kernel = $app->make(Kernel::class);
$response = $kernel->handle($request);

echo "Status: " . $response->getStatusCode() . "\n";
echo "Content (first 500 chars):\n" . substr($response->getContent(), 0, 500) . "\n";

// Contar estabelecimentos
$data = json_decode($response->getContent(), true);
if (is_array($data)) {
    echo "Count: " . count($data) . "\n";
    if (count($data) > 0) {
        echo "First ID: " . ($data[0]['id'] ?? 'N/A') . "\n";
    }
}
