<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

use Tymon\JWTAuth\Facades\JWTAuth;

// Configurar o token manualmente
$token = ''eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvYXBpLmV1bGV2b2FpLmNvbS5iclwvYXBpXC9sb2dpbiIsImlhdCI6MTc2ODk5OTk1MiwiZXhwIjoxNzY5MDM1OTUyLCJuYmYiOjE3Njg5OTk5NTIsImp0aSI6IjAxYVR5NzRrbGtwbWlHMzkiLCJzdWIiOjcsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjciLCJ0ZW5hbnRfaWQiOjcsInR5cGUiOiJFIiwibmFtZSI6IkpvcmdlIEx1aXMgU2FudG9zIGRlIFNhbnRhbmEgRUlSRUxJIiwiZW1haWwiOiJmcmlnb3JpZmljby5zYW8uam9yZ2VAaG90bWFpbC5jb20ifQ.Igvimwvq4AYDWDBI7d5fRUVzVQBNIdDRaU_uDWTsu18''; // Será substituído

try {
    // Teste 1: Tentar fazer parse do token
    echo "Testando token: " . substr($token, 0, 30) . "...\n";
    
    // Configurar o token no JWTAuth
    JWTAuth::setToken($token);
    
    // Tentar autenticar
    $user = JWTAuth::authenticate($token);
    
    echo "SUCESSO! Usuário autenticado:\n";
    echo "ID: " . $user->id . "\n";
    echo "Type: " . $user->type . "\n";
    echo "Tenant ID: " . $user->tenant_id . "\n";
    
} catch (Exception $e) {
    echo "ERRO: " . $e->getMessage() . "\n";
    echo "Classe: " . get_class($e) . "\n";
    
    if ($e instanceof Tymon\JWTAuth\Exceptions\TokenInvalidException) {
        echo "Token inválido\n";
    } elseif ($e instanceof Tymon\JWTAuth\Exceptions\TokenExpiredException) {
        echo "Token expirado\n";
    } else {
        echo "Outro erro\n";
    }
}
