<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';

use App\Models\Tenant;
use Illuminate\Http\Request;

// Simular request com token
$token = ''eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvYXBpLmV1bGV2b2FpLmNvbS5iclwvYXBpXC9sb2dpbiIsImlhdCI6MTc2OTAwMDk0NCwiZXhwIjoxNzY5MDM2OTQ0LCJuYmYiOjE3NjkwMDA5NDQsImp0aSI6IkJiSDkyYVdnUmdOc1hTankiLCJzdWIiOjcsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjciLCJ0ZW5hbnRfaWQiOjcsInR5cGUiOiJFIiwibmFtZSI6IkpvcmdlIEx1aXMgU2FudG9zIGRlIFNhbnRhbmEgRUlSRUxJIiwiZW1haWwiOiJmcmlnb3JpZmljby5zYW8uam9yZ2VAaG90bWFpbC5jb20ifQ.IfvZieOdoVXArOmJpzAWKdwtR3f8Y546GPjADxhlSKU'';
$request = Request::create('/api/establishments', 'GET');
$request->headers->set('Authorization', 'Bearer ' . $token);

// Tentar autenticar
try {
    $user = \Tymon\JWTAuth\Facades\JWTAuth::setToken($token)->authenticate();
    echo "User authenticated: " . $user->id . "\n";
    
    // Testar query
    if ($user->type === 'admin') {
        $tenants = Tenant::where('type', 'E')->get();
    } else {
        $tenants = Tenant::where('id', $user->tenant_id)
                        ->where('type', 'E')
                        ->get();
    }
    
    echo "Query result: " . $tenants->count() . " tenants\n";
    echo "SQL: " . $tenants->toSql() . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
