document.addEventListener('DOMContentLoaded', function() {
    const token = localStorage.getItem('token') || 
                 document.cookie.match(/token=([^;]+)/)?.[1];
    
    if (!token) return;
    
    // Atualizar estabelecimentos
    fetch('https://api.eulevoai.com.br/api/establishments', {
        headers: { 'X-Authorization': 'Bearer ' + token }
    })
    .then(r => r.json())
    .then(data => {
        const count = Array.isArray(data) ? data.length : 1;
        const el = document.getElementById('establishment-counter');
        if (el) el.textContent = count;
        console.log('Estabelecimentos atualizados:', count);
    })
    .catch(err => console.error('Erro estabelecimentos:', err));
    
    // Poderia adicionar outros endpoints aqui
});
