document.addEventListener('DOMContentLoaded', function() {
    const token = localStorage.getItem('token') || 
                 document.cookie.match(/token=([^;]+)/)?.[1];
    
    if (!token) return;
    
    // 1. Estabelecimentos
    fetch('https://api.eulevoai.com.br/api/establishments', {
        headers: { 'X-Authorization': 'Bearer ' + token }
    })
    .then(r => r.json())
    .then(data => {
        const count = Array.isArray(data) ? data.length : 1;
        updateCounter('establishment-counter', count);
    });
    
    // 2. Pedidos (se houver endpoint)
    // fetch('https://api.eulevoai.com.br/api/orders/count', {...})
    // .then(r => r.json())
    // .then(data => updateCounter('order-counter', data.count || 0));
    
    // 3. Usuários (se houver endpoint)  
    // fetch('https://api.eulevoai.com.br/api/users/count', {...})
    // .then(r => r.json())
    // .then(data => updateCounter('user-counter', data.count || 0));
    
    // 4. Entregadores (se houver endpoint)
    // fetch('https://api.eulevoai.com.br/api/couriers/count', {...})
    // .then(r => r.json())
    .then(data => updateCounter('courier-counter', data.count || 0));
});

function updateCounter(id, value) {
    const el = document.getElementById(id);
    if (el) {
        el.textContent = value;
        console.log(`Counter ${id} updated: ${value}`);
    }
}
