// Script para corrigir contador hardcoded
document.addEventListener('DOMContentLoaded', function() {
    // Encontrar elemento com 617
    const counters = document.querySelectorAll('h2.font-weight-bold');
    counters.forEach(counter => {
        if (counter.textContent.trim() === '617') {
            // Buscar contador real da API
            const token = localStorage.getItem('token') || 
                         document.cookie.match(/token=([^;]+)/)?.[1];
            
            if (token) {
                fetch('https://api.eulevoai.com.br/api/establishments', {
                    headers: {
                        'X-Authorization': 'Bearer ' + token
                    }
                })
                .then(response => response.json())
                .then(data => {
                    // Se for array, contar elementos
                    const count = Array.isArray(data) ? data.length : 1;
                    counter.textContent = count;
                    console.log('Contador atualizado:', count);
                })
                .catch(error => {
                    console.error('Erro ao buscar contador:', error);
                    counter.textContent = '1'; // Fallback
                });
            } else {
                counter.textContent = '1'; // Fallback
            }
        }
    });
});
