<?php

require __DIR__.'/../vendor/autoload.php';

use CoffeeCode\Router\Router;

$router = new Router(ROOT);

/*
 * Controllers
 */
$router->namespace('App\Controllers');

/*
 * LOGIN
 */
$router->group(null);
$router->get('/login', 'Auth:login');


/*
 * DASHBOARD
 */
$router->get('/dashboard', 'Home:index', "name.home");


/*
 * CIDADES
 */
$router->get('/cidades', 'City:index');


/*
 * ESTABELECIMENTOS
 */
$router->get('/estabelecimentos', 'Establishment:index');


/*
 * SEGMENTOS
 */
$router->get('/segmentos', 'Segment:index');


/*
 * GATEWAY DE PAGAMENTO
 */
$router->get('/gateway', 'Gateway:index');


/*
 * BAIRROS
 */
$router->get('/bairros', 'Neighborhood:index');


/*
 * CLIENTE
 */
$router->get('/clientes', 'Client:index');


/*
 * ENTREGADORES
 */
$router->get('/entregadores', 'Courier:index');


/*
 * CATEGORIAS
 */
$router->get('/categorias', 'Category:index');


/*
 * SUBCATEGORIAS
 */
$router->get('/subcategorias', 'SubCategory:index');


/*
 * PRODUTOS
 */
$router->get('/produtos', 'Product:index');


/*
 * FORMA DE PAGAMENTO
 */
$router->get('/pagamentos', 'Payment:index');


/*
 * CUPOM DE DESCONTO
 */
$router->get('/cupons', 'Coupon:index');


/*
 * CUPOM DE DESCONTO
 */
$router->get('/banners', 'Banner:index');


/*
 * CONFIGURAÇÕES
 */
$router->get('/configuracoes', 'Config:index');


/*
 * MEUS DADOS
 */
$router->get('/meus-dados', 'Profile:index');


/*
 * ERRORS
 */
//$router->group('error');
//$router->get('/{error_code}', 'Error:{error_code}');





/*
 * PROCESS
 */
$router->dispatch();


/*
 * Redirect all errors
 */
//if ($router->error()) {
//    $router->redirect("/error/{$router->error()}");
//}
