// Atualiza todos os contadores do dashboard com dados reais da API
document.addEventListener('DOMContentLoaded', function() {
    const token = localStorage.getItem('token') || 
                 document.cookie.match(/token=([^;]+)/)?.[1];
    
    if (!token) {
        console.warn('Token não encontrado. Contadores não serão atualizados.');
        return;
    }
    
    const headers = {
        'X-Authorization': 'Bearer ' + token
    };
    
    // 1. Estabelecimentos
    fetch('https://api.eulevoai.com.br/api/establishments', { headers })
        .then(r => r.json())
        .then(data => updateCounter('establishment-counter', Array.isArray(data) ? data.length : 1))
        .catch(err => console.error('Erro estabelecimentos:', err));
    
    // 2. Usuários
    fetch('https://api.eulevoai.com.br/api/users', { headers })
        .then(r => r.json())
        .then(data => updateCounter('user-counter', Array.isArray(data) ? data.length : 0))
        .catch(err => console.error('Erro usuários:', err));
    
    // 3. Entregadores
    fetch('https://api.eulevoai.com.br/api/couriers', { headers })
        .then(r => r.json())
        .then(data => updateCounter('courier-counter', Array.isArray(data) ? data.length : 0))
        .catch(err => console.error('Erro entregadores:', err));
    
    // 4. Pedidos - endpoint não existe, manter 0 ou tentar buscar se existir
    // fetch('https://api.eulevoai.com.br/api/orders', { headers })
    //     .then(r => r.json())
    //     .then(data => updateCounter('order-counter', Array.isArray(data) ? data.length : 0))
    //     .catch(() => updateCounter('order-counter', 0));
    
    // Atualizar pedidos para 0 (sem endpoint)
    updateCounter('order-counter', 0);
});

function updateCounter(id, value) {
    const el = document.getElementById(id);
    if (el) {
        el.textContent = value;
        console.log(`Contador ${id} atualizado: ${value}`);
    }
}
