// Fix global para X-Authorization
(function() {
    // Interceptar fetch
    const originalFetch = window.fetch;
    window.fetch = function(url, options = {}) {
        if (options.headers && options.headers.Authorization) {
            options.headers['X-Authorization'] = options.headers.Authorization;
            delete options.headers.Authorization;
        }
        return originalFetch.call(this, url, options);
    };
    
    // Interceptar XMLHttpRequest
    const originalXHROpen = XMLHttpRequest.prototype.open;
    const originalXHRSetRequestHeader = XMLHttpRequest.prototype.setRequestHeader;
    
    XMLHttpRequest.prototype.open = function() {
        this._requestHeaders = {};
        return originalXHROpen.apply(this, arguments);
    };
    
    XMLHttpRequest.prototype.setRequestHeader = function(header, value) {
        if (header.toLowerCase() === 'authorization') {
            this._requestHeaders['X-Authorization'] = value;
        } else {
            this._requestHeaders[header] = value;
        }
        return originalXHRSetRequestHeader.call(this, header, value);
    };
    
    // Sobrescrever send para aplicar headers
    const originalSend = XMLHttpRequest.prototype.send;
    XMLHttpRequest.prototype.send = function(body) {
        // Aplicar headers X-Authorization
        for (const [header, value] of Object.entries(this._requestHeaders || {})) {
            if (header === 'X-Authorization') {
                originalXHRSetRequestHeader.call(this, 'X-Authorization', value);
            }
        }
        return originalSend.call(this, body);
    };
    
    console.log('X-Authorization fix aplicado');
})();
