<!doctype html>
<html lang="en">


    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">

        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <title>Eu levo ai - Login</title>

        <!-- Favicon -->
        <link rel="shortcut icon" href="/assets/media/image/favicon.png" />

        <!-- Plugin styles -->
        <link rel="stylesheet" href="/vendors/bundle.css" type="text/css">

        <!-- App styles -->
        <link rel="stylesheet" href="/assets/css/app.min.css" type="text/css">


    </head>

    <body class="form-membership">

        <!-- begin::preloader-->
        <!-- <div class="preloader">
            <div class="preloader-icon"></div>
        </div> -->
        <!-- end::preloader -->

        <div class="form-wrapper">


            <!-- logo -->
            <div id="logo">
                <img class="logo" src="assets/media/image/logo.png" alt="image">
                <img class="logo-dark" src="assets/media/image/logo-dark.html" alt="image">
            </div>
            <!-- ./ logo -->

            <h5>Acesso ao sistema</h5>

            <div id="response"></div>

            <!-- form -->
            <form id='login_form'>
                <div class='form-group'>
                    <input type='email' class='form-control' id='email' name='email' placeholder='E-mail'>
                </div>

                <div class='form-group'>
                    <input type='password' class='form-control' id='password' name='password' placeholder='Senha'>
                </div>

                <button type='submit' class='btn btn-primary'>Login</button>
            </form>
            <!-- ./ form -->


        </div>

        <!-- Plugin scripts -->
        <script src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
        <script src="/vendors/bundle.js"></script>
        <script src="/assets/js/app.min.js"></script>

        <script>
            $(document).ready(function () {

                $(document).on('submit', '#login_form', function () {

                    // get form data
                    var login_form = $(this);
                    var form_data = JSON.stringify(login_form.serializeObject());
                    var api = '<?php echo API; ?>';

                    // submit form data to api
                    $.ajax({
                        url: api + "login",
                        type: "POST",
                        contentType: 'application/json',
                        data: form_data,
                        success: function (result) {

                            // store jwt to cookie
                            sessionStorage.setItem('MyUniqueUserToken', JSON.stringify(result.access_token));

                            me();

                            window.setTimeout(function () {
                                logo();
                            }, 1000);


                            // show home page & tell the user it was a successful login
                            $('#response').html("<div class='alert alert-success'>Bem-Vindo ao EuLevoAi</div>");

                            // show Home Page
                            window.setTimeout(function () {
                                window.location = '/dashboard';
                            }, 2000);


                        },
                        error: function (xhr, resp, text) {
                            // on error, tell the user login has failed & empty the input boxes
                            $('#response').html("<div class='alert alert-danger'>E-mail ou senha incorreto.</div>");
                            login_form.find('input').val('');
                        }
                    });

                    return false;
                });


                $.fn.serializeObject = function () {
                    var o = {};
                    var a = this.serializeArray();
                    $.each(a, function () {
                        if (o[this.name] !== undefined) {
                            if (!o[this.name].push) {
                                o[this.name] = [o[this.name]];
                            }
                            o[this.name].push(this.value || '');
                        } else {
                            o[this.name] = this.value || '';
                        }
                    });
                    return o;
                };
            });


            function me()
            {
                var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
                var api = '<?php echo API; ?>';
                var img = '<?php echo IMG; ?>';

                $.ajax({
                    url: api + "me",
                    type: "POST",
                    contentType: 'application/json',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (result) {
                        // store type
                        sessionStorage.setItem('Me', JSON.stringify(result.type));
                        sessionStorage.setItem('Id', JSON.stringify(result.id));
                        sessionStorage.setItem('Name', JSON.stringify(result.name));
                    }
                });
            }

            function logo()
            {
                var id = JSON.parse(sessionStorage.getItem('Id'));
                var api = '<?php echo API; ?>';
                var img = '<?php echo IMG; ?>';
                var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

                $.ajax({
                    url: api + "configuration/" + id,
                    type: 'GET',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {
                        var data = JSON.parse(JSON.stringify(data));
                        
                        icon = img + id + '/favicon.jpg';
                        sessionStorage.setItem('Logo', icon);

                    }
                });
            }
        </script>
    </body>


</html>