<?php $v->layout('layouts/main', ['title' => 'Categorias']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Categorias</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Categorias</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadCategoria">
                    <i class="fa fa-plus"></i> &nbsp; Nova Categoria
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="categories" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Categoria</th>
                                <th>Descrição</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR SEGMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadCategoria">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Categoria</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarCategoria">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="name">Categoria</label>
                                <input type="text" class="form-control" name="name" placeholder="Categoria" maxlength="30">
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="description">Descrição</label>
                                <input type="text" class="form-control" name="description" placeholder="Descrição" maxlength="100">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadCategoria">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR SEGMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditCategoria">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Categoria</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarCategoria">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <input type="hidden" id="id_category">
                                <label for="name">Categoria</label>
                                <input type="text" class="form-control" name="name" placeholder="Categoria" maxlength="30" id="name_category">
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="description">Descrição</label>
                                <input type="text" class="form-control" name="description" placeholder="Descrição" maxlength="100" id="description_category">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditCategoria">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>


<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };


    // carregar a tabela de categorias
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#components_e > a').addClass("active");
        $('div#components').addClass("open");
        $('a#categorias').addClass("active");
        
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#categories').DataTable({
            "ajax": {
                "url": api + "categories",
                "type": 'GET',
                "headers": {'Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": "description"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // cadastrar o categoria
        $(document).on('click', '#btnCadCategoria', function () {

            // get form data
            var form_data = $('#frmCadastrarCategoria').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "categories",
                type: 'POST',
                headers: {'Authorization': `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Categoria cadastrada com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarCategoria').trigger("reset");
                    $('#modalCadCategoria').modal('hide');
                    $('#categories').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditCategoria').on('hidden.bs.modal', function () {
            $('#frmEditarCategoria input').each(function () {
                $(this).val('');
                tagify.removeAllTags();
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';


            // submit form data to api
            $.ajax({
                url: api + "categories/" + item_id,
                type: 'GET',
                headers: {'Authorization': `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_category').val(data.id);
                    $('#name_category').val(data.name);
                    $('#description_category').val(data.description);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditCategoria').modal('show');
        });


        // editar o categoria
        $(document).on('click', '#btnEditCategoria', function () {

            var id = $('#id_category').val();
            var form_data = $('#frmEditarCategoria').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "categories/" + id,
                type: 'PUT',
                headers: {'Authorization': `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Categoria alterada com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarCategoria').trigger("reset");
                    $('#modalEditCategoria').modal('hide');
                    $('#categories').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });



        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar este categoria?');
            if (confirmado) {

                $.ajax({
                    url: api + "categories/" + item_id,
                    type: 'DELETE',
                    headers: {'Authorization': `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Categoria excluída com sucesso!',
                            timeout: 6000,
                        });

                        $('#categories').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>