<?php $v->layout('layouts/main', ['title' => 'Cidades']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Cidades</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Cidades</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadCidade">
                    <i class="fa fa-plus"></i> &nbsp; Nova Cidade
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="cities" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Cidade</th>
                                <th>UF</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR CIDADE -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadCidade">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Cidade</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarCidade">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input type="text" class="form-control" name="code" placeholder="Código" maxlength="30">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Cidade</label>
                                <input type="text" class="form-control" name="name" placeholder="Cidade" maxlength="30">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="uf">UF</label>
                                <input type="text" class="form-control" name="uf" placeholder="UF" maxlength="2">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadCidade">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR CIDADE -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditCidade">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Cidade</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarCidade">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_city">
                                <label for="code">Código</label>
                                <input type="text" class="form-control" name="code" placeholder="Código" maxlength="30" id="code_city">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Cidade</label>
                                <input type="text" class="form-control" name="name" placeholder="Cidade" maxlength="30" id="name_city">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="uf">UF</label>
                                <input type="text" class="form-control" name="uf" placeholder="UF" maxlength="2" id="uf_city">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditCidade">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"A"') {
            return logout();
        }
    };

    // carregar a tabela de cidades
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#analytics_a > a').addClass("active");
        $('div#analytics').addClass("open");
        $('a#cidades').addClass("active");

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#cities').DataTable({
            "ajax": {
                "url": api + "cities",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "code"},
                {"data": "name"},
                {"data": "uf"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // cadastrar o cidade
        $(document).on('click', '#btnCadCidade', function () {

            // get form data
            var form_data = $('#frmCadastrarCidade').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "cities",
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Cidade cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarCidade').trigger("reset");
                    $('#modalCadCidade').modal('hide');
                    $('#cities').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditCidade').on('hidden.bs.modal', function () {
            $('#frmEditarCidade input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "cities/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_city').val(data.id);
                    $('#code_city').val(data.code);
                    $('#name_city').val(data.name);
                    $('#uf_city').val(data.uf);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditCidade').modal('show');
        });


        // editar o cidade
        $(document).on('click', '#btnEditCidade', function () {

            var id = $('#id_city').val();
            var form_data = $('#frmEditarCidade').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "cities/" + id,
                type: 'PUT',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Cidade alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarCidade').trigger("reset");
                    $('#modalEditCidade').modal('hide');
                    $('#cities').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar esta forma de cidade?');
            if (confirmado) {

                $.ajax({
                    url: api + "cities/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Cidade excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#cities').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });

    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>